package gov.va.med.mhv.integration.phr.stage.transfer;

import java.util.Date;

import org.apache.commons.lang3.StringUtils;

/**
 * StageReminder entity.
 *
 */

public class StageWellnessReminder extends StageEntity  {

	// Fields
    private String ien;

    private Date extractDate;
    private String wellnessStatus;
    private String subject;
	private String fullSummary;
    private Date dueDatePrecise;
    private String dueDateImprecise;
    private Date dateLastDonePrecise;
    private String dateLastDoneImprecise;

    // Constructors

	/** default constructor
     *  do not provide auto initialization since this class can be used in findByExample
     * */
	public StageWellnessReminder() {
        super();
    }

	/** minimal constructor */
	public StageWellnessReminder(Long oplock, Date createdDate, Date modifiedDate,
			String icn, String stationNumber, Long requestMsgCtrlId) {
        super();
        this.oplock = oplock;
		this.createdDate = createdDate;
		this.modifiedDate = modifiedDate;
        this.extractDate = modifiedDate;
        this.icn = icn;
		this.stationNumber = stationNumber;
		this.requestMsgCtrlId = requestMsgCtrlId;
	}

	// Property accessors

	public String getIen() {
		return this.ien;
	}

	public void setIen(String ien) {
		this.ien = ien;
	}

	public String getWellnessStatus() {
		return this.wellnessStatus;
	}

	public void setWellnessStatus(String wellnessStatus) {
		this.wellnessStatus = doubleUnescapeHtml(wellnessStatus);
	}

    public Date getExtractDate() {
        return extractDate;
    }

    public void setExtractDate(Date extractDate) {
        this.extractDate = extractDate;
    }

    public String getSubject() {
        return subject;
    }

    public void setSubject(String subject) {
        this.subject = doubleUnescapeHtml(subject);
    }

    public String getFullSummary() {
        return fullSummary;
    }

    public void setFullSummary(String fullSummary) {
        this.fullSummary = doubleUnescapeHtml(fullSummary);
    }

    public String getDueDateImprecise() {
        return dueDateImprecise;
    }

    public void setDueDateImprecise(String dueDateImprecise) {
        this.dueDateImprecise = dueDateImprecise;
    }

    public String getDateLastDoneImprecise() {
        return dateLastDoneImprecise;
    }

    public void setDateLastDoneImprecise(String dateLastDoneImprecise) {
        this.dateLastDoneImprecise = dateLastDoneImprecise;
    }


    public String toString() {
        return "StageWellnessReminder{" +
                "extractDate=" + extractDate +
                ", subject='" + subject + '\'' +                
                ", wellnessStatus='" + wellnessStatus + '\'' +
                ", dueDateImprecise='" + dueDateImprecise + '\'' +
                ", dateLastDoneImprecise='" + dateLastDoneImprecise + '\'' +
                ", fullSummary='" + fullSummary + '\'' +
                '}';
    }
    
    public String toCompare(){
    	return "" + getDateLastDoneImprecise()+
    			getDueDateImprecise()+
    			StringUtils.deleteWhitespace(getFullSummary())+
    			getIen()+
    			getSubject()+
    			getWellnessStatus();
    }
}
